using System;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// Base class for all exceptions that may occur during string/XML parsing
	/// and/or deserialization from the corresponding mediums. 
	/// </summary>
	public class FlatMediumParseException : VistALinkException
	{
		/// <summary>
		/// Default parameterless constructor. Should be avoided whenever possible.
		/// </summary>
		public FlatMediumParseException() 
			: base() {}

		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public FlatMediumParseException( string message )
			: base( message ) {}

		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="inner">Inner exception that caused this exception.</param>
		public FlatMediumParseException( string message, Exception inner )
			: base( message, inner ) {}
	}
}
